#include <iostream>
#include <algorithm>
#include <vector>
#include <math.h>
#include <chrono>

#define MAX 200000

using std::vector;

bool P[MAX+1];

vector<int> prosti(2);

void eratosten(int n) {
  for(int i=2; i < sqrt(n); i++) {
  	if(P[i]) {
    	for(int j=i; j < n/i; j++)
     		P[i*j]=false;
   		}
	}
}

// prosti[0] su korisni, prosti[1] su neupotrebljeni
void racunaj_proste(int n, int granica) {
    for(int i=3;i<=n;i+=2) {
        if(i<=granica && P[i]==true) {
            prosti[0]++;
        } else if (P[i]==true)
            prosti[1]++;
    }
}


int main() {
	int Q, N;
	std::cin >> Q;
	
	for(int i=0;i<MAX;i++)
		P[i]=true;
	
	eratosten(MAX);
	
	vector<int> v(Q);

	for(int i=0;i<Q;i++) {
		std::cin >> v[i];
	}
	
	auto start = std::chrono::system_clock::now();
	for(int i=0;i<Q;i++) {
	    N = v[i];
		int parni_br=N/2; // minimum razlicitih, svi slucajevi za parne brojeve do N reseni
		
		int N2; // N2 je N bez parnih brojeva
		N2=N/2;

		racunaj_proste(N, N2);
		
		int f = N-(parni_br + prosti[0] + prosti[1]);
		int ukup_br = parni_br + prosti[0] + f-1;
		
		prosti[0] = 0;
		prosti[1] = 0;
		
		std::cout << ukup_br << std::endl;
    }
	
	return 0;
}